/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.github.IGithubPullRequest;
import com.aptana.git.core.github.IGithubRepository;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractGithubHandler;
import com.aptana.git.ui.internal.actions.Messages;
import com.aptana.ui.MenuDialogItem;
import com.aptana.ui.QuickMenuDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;

public class MergePullRequestHandler
extends AbstractGithubHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository repo = this.getSelectedRepository();
        if (repo == null) {
            throw new ExecutionException(Messages.CreatePullRequestHandler_NoRepoErr);
        }
        IGithubRepository ghRepo = this.getGithubRepo();
        if (ghRepo == null) {
            return null;
        }
        try {
            List prs = ghRepo.getOpenPullRequests();
            ArrayList<MenuDialogItem> listOfMaps = new ArrayList<MenuDialogItem>();
            for (IGithubPullRequest pr : prs) {
                listOfMaps.add(new MenuDialogItem(pr.getDisplayString()));
            }
            if (!listOfMaps.isEmpty()) {
                QuickMenuDialog dialog = new QuickMenuDialog(this.getShell(), "Merge Pull Request");
                dialog.setInput(listOfMaps);
                if (dialog.open() != -1) {
                    IGithubPullRequest pr = (IGithubPullRequest)prs.get(dialog.getReturnCode());
                    MergePullRequestHandler.mergePullRequest(repo, pr);
                }
            }
        }
        catch (CoreException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

